/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.internal.core

import groovy.transform.CompileStatic
import org.gradle.api.Action
import org.gradle.api.Project
import org.gradle.api.file.DeleteSpec
import org.gradle.api.logging.LogLevel
import org.gradle.api.provider.Provider
import org.gradle.api.provider.ProviderFactory
import org.gradle.api.tasks.WorkResult
import org.ysb33r.grolifant5.api.core.ConfigurationPhaseOperations
import org.ysb33r.grolifant5.api.core.ConfigurationTools
import org.ysb33r.grolifant5.api.core.ExecTools
import org.ysb33r.grolifant5.api.core.FileSystemOperations
import org.ysb33r.grolifant5.api.core.GrolifantProblemReporter
import org.ysb33r.grolifant5.api.core.JvmTools
import org.ysb33r.grolifant5.api.core.ProjectOperations
import org.ysb33r.grolifant5.api.core.ProjectTools
import org.ysb33r.grolifant5.api.core.ProviderTools
import org.ysb33r.grolifant5.api.core.RepositoryTools
import org.ysb33r.grolifant5.api.core.StringTools
import org.ysb33r.grolifant5.api.core.TaskTools

import javax.inject.Inject
import java.util.concurrent.Callable

import static org.ysb33r.grolifant5.internal.core.DeprecatedProjectOperationsReporter.report

/**
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.5
 *
 * @deprecated Will be removed in 6.0
 */
@Deprecated
@CompileStatic
@SuppressWarnings('LineLength')
class LegacyProjectOperations implements ProjectOperations {
    private static final String PREFIXMSG = 'Use (ConfigurationPhaseOperations|grolifantOps)'

    @Inject
    LegacyProjectOperations(Project project) {
        this.cpo = ConfigurationPhaseOperations.from(project)
    }

    @Override
    ConfigurationPhaseOperations getConfigurationPhaseOperations() {
        this.cpo
    }

    @Override
    Provider<ProjectOperations> asProvider() {
        report(
            cpo,
            'asProvider will be removed',
            'There will be no alternative. Using a Provider to this class would probably lead to ' +
                'problems in later releases of Gradle.'
        )
        cpo.providerTools().provider { -> (ProjectOperations) owner }
    }

    @Override
    WorkResult delete(Action<? super DeleteSpec> action) {
        report(cpo, 'delete', "${PREFIXMSG}.fsOperations().delete()")
        cpo.fsOperations().delete(action)
    }

    @Override
    Provider<File> getBuildDir() {
        report(cpo, 'getBuildDir', 'Use project.getLayout().getBuildDirectory()')
        cpo.fsOperations().buildDirDescendant('.')
    }

    @Override
    ConfigurationTools getConfigurations() {
        report(cpo, 'getConfigurations', "${PREFIXMSG}.configurationTools()")
        cpo.configurationTools()
    }

    @Override
    ExecTools getExecTools() {
        report(cpo, 'getExecTools', "${PREFIXMSG}.execTools()")
        cpo.execTools()
    }

    @Override
    String getFullProjectPath() {
        report(cpo, 'getFullProjectPath', "${PREFIXMSG}.projectTools().getFullProjectPath()")
        cpo.projectTools().fullProjectPath
    }

    @Override
    Provider<String> getGroupProvider() {
        report(cpo, 'getGroupProvider', "${PREFIXMSG}.projectTools().getGroupProvider()")
        cpo.projectTools().groupProvider
    }

    @Override
    FileSystemOperations getFsOperations() {
        report(cpo, 'getFsOperations', "${PREFIXMSG}.fsOperations()")
        cpo.fsOperations()
    }

    @Override
    String getProjectName() {
        report(cpo, 'getProjectName', "${PREFIXMSG}.projectTools().getProjectNameProvider()")
        cpo.projectTools().projectNameProvider.get()
    }

    @Override
    String getProjectPath() {
        report(cpo, 'getProjectPath', "${PREFIXMSG}.projectTools().getFullProjectPath()")
        cpo.projectTools().fullProjectPath
    }

    @Override
    File getProjectRootDir() {
        report(cpo, 'getProjectRootDir', "${PREFIXMSG}.fsOperations().getProjectRootDir()")
        cpo.fsOperations().projectRootDir
    }

    @Override
    ProviderFactory getProviders() {
        report(cpo, 'getProviders', 'Use project.providers')
        cpo.providers
    }

    @Override
    ProjectTools getProjectTools() {
        report(cpo, 'getProjectTools', "${PREFIXMSG}.projectTools()")
        cpo.projectTools
    }

    @Override
    ProviderTools getProviderTools() {
        report(cpo, 'getProviderTools', "${PREFIXMSG}.providerTools()")
        cpo.providerTools()
    }

    @Override
    RepositoryTools getRepositoryTools() {
        report(cpo, 'getRepositoryTools', "${PREFIXMSG}.repositoryTools()")
        cpo.repositoryTools()
    }

    @Override
    StringTools getStringTools() {
        report(cpo, 'getStringTools', "${PREFIXMSG}.stringTools()")
        cpo.stringTools()
    }

    @Override
    TaskTools getTasks() {
        report(cpo, 'getTasks', "${PREFIXMSG}.taskTools()")
        cpo.taskTools()
    }

    @Override
    GrolifantProblemReporter getProblemReporter() {
        report(cpo, 'getProblemReporter', "${PREFIXMSG}.problemReporter()")
        cpo.problemReporter()
    }

    @Override
    LogLevel getGradleLogLevel() {
        report(cpo, 'getGradleLogLevel', "${PREFIXMSG}.projectTools().getGradleLogLevel()")
        cpo.projectTools().gradleLogLevel
    }

    @Override
    boolean isConfigurationCacheEnabled() {
        report(cpo, 'isConfigurationCacheEnabled', "${PREFIXMSG}.projectTools().isConfigurationCacheEnabled()")
        cpo.projectTools().configurationCacheEnabled
    }

    @Override
    boolean isOffline() {
        report(cpo, 'isOffline', "${PREFIXMSG}.projectTools().getOfflineProvider()")
        cpo.projectTools().offlineProvider.get()
    }

    @Override
    boolean isRoot() {
        report(cpo, 'isRoot', "${PREFIXMSG}.projectTools().isRootProject()")
        cpo.projectTools().rootProject
    }

    @Override
    JvmTools getJvmTools() {
        report(cpo, 'getJvmTools', "${PREFIXMSG}.jvmTools()")
        cpo.jvmTools()
    }

    @Override
    public <T> Provider<T> provider(Callable<? extends T> var1) {
        report(cpo, 'provider', "${PREFIXMSG}.providerTools.provider OR project.provider")
        cpo.providerTools().provider(var1)
    }

    private final ConfigurationPhaseOperations cpo
}
