/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.loadable.core

import groovy.transform.CompileStatic
import org.gradle.StartParameter
import org.gradle.api.Project
import org.gradle.api.invocation.Gradle
import org.gradle.api.provider.ProviderFactory
import org.ysb33r.grolifant5.api.core.ConfigurationPhaseOperations
import org.ysb33r.grolifant5.api.core.ConfigurationTools
import org.ysb33r.grolifant5.api.core.ExecTools
import org.ysb33r.grolifant5.api.core.FileSystemOperations
import org.ysb33r.grolifant5.api.core.GrolifantProblemReporter
import org.ysb33r.grolifant5.api.core.JvmTools
import org.ysb33r.grolifant5.api.core.ProjectTools
import org.ysb33r.grolifant5.api.core.ProviderTools
import org.ysb33r.grolifant5.api.core.RepositoryTools
import org.ysb33r.grolifant5.api.core.StringTools
import org.ysb33r.grolifant5.api.core.TaskTools
import org.ysb33r.grolifant5.internal.core.loaders.ConfigurationToolsLoader
import org.ysb33r.grolifant5.internal.core.loaders.ExecToolsLoader
import org.ysb33r.grolifant5.internal.core.loaders.FileSystemOperationsLoader
import org.ysb33r.grolifant5.internal.core.loaders.GrolifantProblemReporterLoader
import org.ysb33r.grolifant5.internal.core.loaders.JvmToolsLoader
import org.ysb33r.grolifant5.internal.core.loaders.ProjectToolsLoader
import org.ysb33r.grolifant5.internal.core.loaders.ProviderToolsLoader
import org.ysb33r.grolifant5.internal.core.loaders.RepositoryToolsLoader
import org.ysb33r.grolifant5.internal.core.loaders.StringToolsLoader
import org.ysb33r.grolifant5.internal.core.loaders.TaskToolsLoader

import static org.ysb33r.grolifant5.internal.core.DeprecatedProjectOperationsReporter.reportExt

@SuppressWarnings(['MethodCount', 'AbstractClassWithoutAbstractMethod'])
@CompileStatic
abstract class ProjectOperationsProxy implements ConfigurationPhaseOperations {

//    @Override
//    WorkResult delete(Action<? super DeleteSpec> action) {
//        fsOperations.delete(action)
//    }

    @Override
    ConfigurationTools configurationTools() {
        this.configurationTools
    }

    @Override
    ExecTools execTools() {
        this.execTools
    }

    @Override
    FileSystemOperations fsOperations() {
        this.fsOperations
    }

    /**
     * A reference to the provider factory.
     *
     * @return {@link ProviderFactory}
     */
    @Override
    @Deprecated
    ProviderFactory getProviders() {
        reportExt(
            this,
            'getProviders will be removed in Grolifant 6.0',
            'Use project.providers'
        )
        this.providerFactory
    }

    @Override
    TaskTools taskTools() {
        this.taskTools
    }

//    /**
//     * Whether configuration cache is enabled for a build.
//     *
//     * @return {@code true} is configuration cache is available and enabled.
//     */
//    @Override
//    boolean isConfigurationCacheEnabled() {
//        this.configurationCacheEnabled
//    }

//    /**
//     * Whether Gradle is operating in offline mode.
//     *
//     * @return {@code true} if offline.
//     */
//    @Override
//    boolean isOffline() {
//        this.offline
//    }

//    /**
//     * Executes the specified external java process.
//     * @param action
//     * @return {@link ExecResult} that can be used to check if the execution worked.
//     *
//     */
//    @Override
//    ExecResult javaexec(Action<? super JavaExecSpec> action) {
//        execOperations.javaexec(action)
//    }

//    /**
//     * Get the minimum log level for Gradle.
//     *
//     * @return Log level
//     */
//    @Override
//    LogLevel getGradleLogLevel() {
//        this.logLevel
//    }
//
//    /**
//     * Get the full project path including the root project name in case of a multi-project.
//     *
//     * @return The fully qualified project path including root project.
//     *
//     * @since 1.2
//     */
//    @Override
//    String getFullProjectPath() {
//        projectTools.fullProjectPath
//    }

//    /**
//     * Lazy-evaluated project group.https://gitlab.com/ysb33rOrg/grolifant/-/jobs/3248448094
//     *
//     * @return provider to project group
//     */
//    @Override
//    Provider<String> getGroupProvider() {
//        projectTools.groupProvider
//    }

    JvmTools jvmTools() {
        this.jvmTools
    }

//    /**
//     * The project name
//     *
//     * @return Cached value of project name.
//     */
//    @Override
//    String getProjectName() {
//        this.projectName
//    }
//
//    /**
//     * Get project path.
//     *
//     * @return The fully qualified project path.
//     *
//     * @since 1.2
//     */
//    @Override
//    String getProjectPath() {
//        this.projectPath
//    }

//    /**
//     * Returns the root directory of the project.
//     *
//     * @return Root directory.
//     *
//     * @since 2.0
//     */
//    @Override
//    File getProjectRootDir() {
//        this.rootDir
//    }
//
    @Override
    ProjectTools projectTools() {
        this.projectTools
    }

    @Override
    ProviderTools providerTools() {
        this.providerTools
    }

    @Override
    RepositoryTools repositoryTools() {
        this.repositoryTools
    }

    @Override
    StringTools stringTools() {
        this.stringTools
    }

    @Override
    GrolifantProblemReporter problemReporter() {
        this.problemReporter
    }

//    /**
//     * Lazy-evaluated project version.
//     *
//     * @return Provider to project version
//     */
//    @Override
//    Provider<String> getVersionProvider() {
//        projectTools.versionProvider
//    }

//    /**
//     * Whether current project is the root project.
//     *
//     * @return {@code true} is current project is root project.
//     *
//     * @since 1.2
//     */
//    @Override
//    boolean isRoot() {
//        this.root
//    }

    protected ProjectOperationsProxy(Project tempProjectReference, final LoadableVersion version) {
//        final po = this
        this.providerFactory = tempProjectReference.providers
//        this.resourceHandler = tempProjectReference.resources

        this.fsOperations = FileSystemOperationsLoader.load(tempProjectReference, version)
        this.taskTools = TaskToolsLoader.load(this, tempProjectReference, version)
        this.repositoryTools = RepositoryToolsLoader.load(this, tempProjectReference, version)
        this.providerTools = ProviderToolsLoader.load(tempProjectReference, version)
        this.projectTools = ProjectToolsLoader.load(tempProjectReference, version)
        this.stringTools = StringToolsLoader.load(tempProjectReference, version)
        this.jvmTools = JvmToolsLoader.load(tempProjectReference, version)
        this.execTools = ExecToolsLoader.load(tempProjectReference, version)
        this.configurationTools = ConfigurationToolsLoader.load(this, tempProjectReference, version)
        this.problemReporter = GrolifantProblemReporterLoader.load(tempProjectReference, version)

//        Gradle gradle = tempProjectReference.gradle
//        StartParameter startParameter = gradle.startParameter

//        this.root = tempProjectReference == tempProjectReference.rootProject
//        this.offline = startParameter.offline
//        this.logLevel = startParameter.logLevel
//        this.gradleHomeDir = providerFactory.provider({ File f -> f }.curry(gradle.gradleHomeDir))
//        this.gradleUserHomeDir = providerFactory.provider({ File f -> f }.curry(gradle.gradleUserHomeDir))
//        this.projectDir = tempProjectReference.projectDir
//        this.rootDir = tempProjectReference.rootDir
//        this.configurationCacheEnabled = ConfigurationCache.isEnabled(tempProjectReference)
//        this.projectName = tempProjectReference.name
//        this.projectPath = tempProjectReference.path
    }

    @Deprecated
    private final ProviderFactory providerFactory
//    private final Provider<File> gradleUserHomeDir
//    private final Provider<File> gradleHomeDir
//    private final File projectDir
//    private final File rootDir
//    private final String projectName
//    private final String projectPath
//    private final boolean root
//    private final boolean offline
//    private final LogLevel logLevel
//    private final ResourceHandler resourceHandler
//    private final boolean configurationCacheEnabled

    private final FileSystemOperations fsOperations
    private final TaskTools taskTools
    private final RepositoryTools repositoryTools
    private final ProviderTools providerTools
    private final ProjectTools projectTools
    private final StringTools stringTools
    private final JvmTools jvmTools
    private final ExecTools execTools
    private final GrolifantProblemReporter problemReporter
    private final ConfigurationTools configurationTools
}
