/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v6.jvm.pre64

import groovy.transform.CompileStatic
import org.gradle.process.CommandLineArgumentProvider
import org.gradle.process.JavaExecSpec
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.internal.core.Transform

/**
 * @author Schalk W. Cronjé
 *
 * @since 4.0
 */
@CompileStatic
class Pre56FakeJavaExecSpec extends Pre46FakeJavaExecSpec {

    Pre56FakeJavaExecSpec(ProjectOperations po) {
        super(po)
        this.projectOperations = po
        this.commandLineArgumentProviders = []
        this.jvmCommandLineArgumentProviders = []

        def proxy = super

        this.commandLineArgumentProviders.add(
            new CommandLineArgumentProvider() {
                @Override
                Iterable<String> asArguments() {
                    Transform.toList(proxy.arguments.commandLineArgumentProviders) {
                        it.get()
                    }.flatten() as Iterable<String>
                }
            }
        )
        this.jvmCommandLineArgumentProviders.add(
            new CommandLineArgumentProvider() {
                @Override
                Iterable<String> asArguments() {
                    Transform.toList(proxy.jvmArguments.commandLineArgumentProviders) {
                        it.get()
                    }.flatten() as Iterable<String>
                }
            }
        )
    }

    JavaExecSpec copyTo(JavaExecSpec target) {
        super.copyTo(target)
        target.argumentProviders.addAll(this.argumentProviders)
        target.jvmArgumentProviders.addAll(this.jvmArgumentProviders)
        me()
    }

    List<CommandLineArgumentProvider> getArgumentProviders() {
        this.commandLineArgumentProviders
    }

    List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        this.jvmCommandLineArgumentProviders
    }

    protected final ProjectOperations projectOperations
    private final List<CommandLineArgumentProvider> commandLineArgumentProviders
    private final List<CommandLineArgumentProvider> jvmCommandLineArgumentProviders
}
