/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v6.jvm.pre66

import groovy.transform.CompileStatic
import org.gradle.api.jvm.ModularitySpec
import org.gradle.api.model.ObjectFactory
import org.gradle.api.provider.Property
import org.gradle.internal.jvm.DefaultModularitySpec
import org.gradle.process.JavaExecSpec
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.internal.v6.jvm.pre64.Pre64FakeJavaExecSpec

/**
 * Create a fake {@link org.gradle.process.JavaExecSpec} for Gradle 6.4 - 6.5
 *
 * @since 2.0
 */
@CompileStatic
class FakeJavaExecSpecPre66 extends Pre64FakeJavaExecSpec {
    FakeJavaExecSpecPre66(ProjectOperations po, ObjectFactory objects) {
        super(po, objects)
        this.modularity = objects.newInstance(DefaultModularitySpec)
        this.mainClass = objects.property(String)
        this.mainModule = objects.property(String)
    }

    final ModularitySpec modularity
    final Property<String> mainClass
    final Property<String> mainModule

//    @Override
    String getMain() {
        mainClass.getOrNull()
    }

//    @Override
    JavaExecSpec setMain(String s) {
        this.mainClass.set(s)
        me()
    }
}
