/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2022
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.loadable.v7

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.file.ArchiveOperations
import org.gradle.api.internal.project.ProjectInternal
import org.ysb33r.grolifant.api.core.ArchiveOperationsProxy

/**
 * Provides an implementation of {@link org.gradle.api.file.ArchiveOperations} that works with Gradle 7.0+.
 *
 * On Gradle < 6.6 it will use the equivalent operations on the {@link Project} object.
 * On Gradle 6.6+ it will use the provided {@link org.gradle.api.file.ArchiveOperations} service.
 *
 * @since 2.0
 */
@CompileStatic
class DefaultArchiveOperations implements ArchiveOperationsProxy {

    DefaultArchiveOperations(Project project) {
        this.archiveOperations = (ArchiveOperations) ((ProjectInternal) project).services.get(
            DefaultArchiveOperations.classLoader.loadClass('org.gradle.api.file.ArchiveOperations')
        )
    }

    @Delegate
    private final ArchiveOperations archiveOperations
}
