/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2022
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v7.executable

import groovy.transform.CompileStatic
import org.gradle.api.provider.Provider
import org.gradle.process.ProcessForkOptions
import org.ysb33r.grolifant.api.core.executable.ExecutableEntryPoint
import org.ysb33r.grolifant.internal.core.runnable.EnvironmentVariableProviders

/**
 * Implementation of an {@link ExecutableEntryPoint} for Gradle 7.0+
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileStatic
class InternalEntryPointProxy implements ExecutableEntryPoint {

    InternalEntryPointProxy(
        ProcessForkOptions instance,
        EnvironmentVariableProviders evp
    ) {
        this.delegate = instance
        this.evp = evp
    }

    /**
     * Adds a provider to environment variables.
     *
     * The values of the provider are processed after any value set via an {@code environment} call.
     *
     * @param envProvider Provider to a resolved map.
     */
    @Override
    void addEnvironmentProvider(Provider<Map<String, String>> envProvider) {
        evp.addEnvironmentProvider(envProvider)
    }

    @Delegate(interfaces = true, deprecated = true, methodAnnotations = true, parameterAnnotations = true)
    private final ProcessForkOptions delegate

    private final EnvironmentVariableProviders evp
}
