/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v7.jvm

import groovy.transform.CompileStatic
import org.gradle.api.model.ObjectFactory
import org.gradle.internal.jvm.Jvm
import org.gradle.process.JavaExecSpec
import org.gradle.process.internal.DefaultJavaExecSpec
import org.ysb33r.grolifant.api.core.ProjectOperations

/**
 * Initialises a JavaExecSpec.
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileStatic
class InitJavaExecSpec {
    static JavaExecSpec initJavaExecSpec(ProjectOperations projectOperations, ObjectFactory objectFactory) {
        JavaExecSpec spec = objectFactory.newInstance(DefaultJavaExecSpec)
        spec.executable = Jvm.current().javaExecutable.absolutePath
        spec.workingDir = projectOperations.projectDir
        spec
    }
}
