/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.loadable.v7

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.loadable.core.ProjectToolsProxy

import static org.ysb33r.grolifant.api.core.LegacyLevel.PRE_7_1

/**
 * @since 2.0
 */
@CompileStatic
class DefaultProjectTools extends ProjectToolsProxy {

    DefaultProjectTools(ProjectOperations po, Project project) {
        super(
            po,
            project,
            PRE_7_1 ? project.provider { -> project.version?.toString() } :
                propertyByName(project, 'version')
                    .orElse(UNSPECIFIED_PROJECT_VERSION)
        )
        if (PRE_7_1) {
            // There was an issue with Gradle properties being loaded to late and that was only fixed in Gradle 7.1
            // We therefore use the legacy approach to get the group & version.
            this.projectGroup = project.provider { ->
                po.stringTools.stringize(project.group ?: UNSPECIFIED_PROJECT_GROUP)
            }
        } else {
            this.projectGroup = propertyByName(project, 'group').orElse(UNSPECIFIED_PROJECT_GROUP)
        }
    }

    /**
     * Lazy-evaluated project group.
     *
     * @return provider to project group
     */
    @Override
    Provider<String> getGroupProvider() {
        this.projectGroup
    }

    static private Provider<String> propertyByName(Project project, String name) {
        project.providers.gradleProperty(name).forUseAtConfigurationTime()
    }

    private final Provider<String> projectGroup
}
