/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.loadable.v8

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.loadable.core.ProjectToolsProxy

/**
 * @since 2.0
 */
@CompileStatic
class DefaultProjectTools extends ProjectToolsProxy {

    DefaultProjectTools(ProjectOperations po, Project project) {
        super(po, project)
        this.projectGroup = propertyByName(project, 'group').orElse(unspecifiedProjectGroup)
        updateVersion(propertyByName(project, 'version').orElse(unspecifiedProjectVersion))
    }

    /**
     * Lazy-evaluated project group.
     *
     * @return provider to project group
     */
    @Override
    Provider<String> getGroupProvider() {
        this.projectGroup
    }

    static private Provider<String> propertyByName(Project project, String name) {
        project.providers.gradleProperty(name)
    }

    private final Provider<String> projectGroup
}
