/*
 * Decompiled with CFR 0.152.
 */
package csv4j;

import com.google.common.base.Preconditions;
import csv4j.RichField;
import csv4j.RichType;
import csv4j.Sane;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Hydrator<T> {
    private static final String DELIMETER = ",";
    private final RichType<T> richType;

    private Hydrator(Class<T> type) {
        this.richType = RichType.of(type);
    }

    public static <U> Hydrator<U> of(Class<U> type) {
        Preconditions.checkNotNull(type);
        return new Hydrator<U>(type);
    }

    public List<T> fromCSV(Path p) {
        String[] csvFields = this.readHeaders(p);
        return this.readDataLines(p, csvFields);
    }

    private String[] readHeaders(Path p) {
        Preconditions.checkNotNull((Object)p);
        try (Stream<String> lines = Sane.fileLines(p);){
            Optional<String> firstLine = lines.findFirst();
            String[] stringArray = firstLine.get().split(DELIMETER);
            return stringArray;
        }
    }

    private List<T> readDataLines(Path p, String[] csvFields) {
        try (Stream<String> lines = Sane.fileLines(p);){
            List list = lines.skip(1L).map(line -> this.toObject(csvFields, line.split(DELIMETER, -1))).collect(Collectors.toList());
            return list;
        }
    }

    private T toObject(String[] csvFields, String[] scvValues) {
        Preconditions.checkState((csvFields.length == scvValues.length ? 1 : 0) != 0);
        T object = Sane.newInstance(this.richType.getType());
        for (int i = 0; i < csvFields.length; ++i) {
            String csvField = csvFields[i];
            String csvValue = scvValues[i];
            RichField richField = this.richType.richFieldOf(csvField);
            if (richField == null || csvValue.isEmpty()) continue;
            richField.setField(object, csvValue);
        }
        return object;
    }
}

