/*
 * Decompiled with CFR 0.152.
 */
package csv4j;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import csv4j.Sane;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class RichField {
    private static final String SET = "set";
    private static final String VALUE_OF = "valueOf";
    private final Field field;
    private final Method setter;

    private RichField(Field field, Method setter) {
        this.field = field;
        this.setter = setter;
    }

    static RichField of(Class<?> type, Field field) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)field);
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        String setterName = RichField.setterName(fieldName);
        Method method = Sane.declaredMethod(type, setterName, fieldType);
        return new RichField(field, method);
    }

    private static String setterName(String fieldName) {
        StringBuilder sb = new StringBuilder(SET);
        sb.append(fieldName.substring(0, 1).toUpperCase());
        sb.append(fieldName.substring(1));
        return sb.toString();
    }

    Field getField() {
        return this.field;
    }

    Method getSetter() {
        return this.setter;
    }

    <T> void setField(T object, String value) {
        Object typedValue = this.valueOfType(value, this.field.getType());
        Sane.invokeMethod(this.setter, object, typedValue);
    }

    private Object valueOfType(String value, Class<?> fieldType) {
        if (fieldType == String.class) {
            return value;
        }
        Class possiblyWrappedFieldType = fieldType.isPrimitive() ? Primitives.wrap(fieldType) : fieldType;
        Method valueOf = Sane.declaredMethod(possiblyWrappedFieldType, VALUE_OF, String.class);
        return Sane.invokeMethod(valueOf, value);
    }
}

