/*
 * Decompiled with CFR 0.152.
 */
package csv4j;

import com.google.common.base.Preconditions;
import csv4j.RichField;
import csv4j.annotations.CsvFields;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

class RichType<T> {
    private final Class<T> type;
    private final Map<String, RichField> jfieldNameToRichField;
    private final Map<String, String> csvfieldToJfield;

    private RichType(Class<T> type) {
        this.type = type;
        this.jfieldNameToRichField = this.jfieldNameToRichField();
        this.csvfieldToJfield = this.csvfieldToJfield();
    }

    static <U> RichType<U> of(Class<U> type) {
        return new RichType<U>(type);
    }

    private Map<String, RichField> jfieldNameToRichField() {
        Field[] fields = this.type.getDeclaredFields();
        return Arrays.asList(fields).stream().collect(Collectors.toMap(Field::getName, f -> RichField.of(this.type, f)));
    }

    private Map<String, String> csvfieldToJfield() {
        Field[] fields;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field f : fields = this.type.getDeclaredFields()) {
            CsvFields annotation = f.getAnnotation(CsvFields.class);
            if (annotation == null) continue;
            String fieldName = f.getName();
            for (String v : annotation.value()) {
                map.put(v, fieldName);
            }
        }
        return map;
    }

    Class<T> getType() {
        return this.type;
    }

    RichField richFieldOf(String csvfield) {
        Preconditions.checkNotNull((Object)csvfield);
        String jfield = this.csvfieldToJfield.get(csvfield);
        return jfield == null ? this.jfieldNameToRichField.get(csvfield) : this.jfieldNameToRichField.get(jfield);
    }
}

