/*
 * Decompiled with CFR 0.152.
 */
package org.yuequan.watchdog.endpoint;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.yuequan.watchdog.client.Application;
import org.yuequan.watchdog.client.ApplicationService;
import org.yuequan.watchdog.endpoint.support.ApplicationParam;

@FrameworkEndpoint
@ResponseBody
public class ApplicationEndpoint {
    @Autowired
    private ApplicationService applicationService;

    @GetMapping(value={"${watchdog.application.prefix:}/applications", "${watchdog.application.prefix:}/applications/", "${watchdog.application.prefix:}/applications/index"})
    public List<Application> index() {
        return this.applicationService.findAll();
    }

    @PostMapping(value={"${watchdog.application.prefix:}/applications", "${watchdog.application.prefix:}/applications/"})
    public ClientDetails create(@RequestBody ApplicationParam param) {
        param.populateDefault();
        Application application = new Application(UUID.randomUUID().toString(), "watchdog", param.getScope(), param.getRedirectUri(), param.getName());
        this.applicationService.addClientDetails(application);
        return this.applicationService.loadClientByClientId(application.getClientId());
    }

    @GetMapping(value={"${watchdog.application.prefix:}/applications/{clientId}"})
    public ClientDetails show(@PathVariable String clientId) {
        return this.applicationService.loadClientByClientId(clientId);
    }

    @PutMapping(value={"${watchdog.application.prefix:}/applications/{clientId}"})
    public ClientDetails update(@PathVariable String clientId, @RequestBody ApplicationParam param) {
        Optional<Application> application = this.applicationService.findByClientId(clientId);
        if (application.isEmpty()) {
            throw new NoSuchClientException("Not Found The Client.");
        }
        application.ifPresent(app -> {
            param.populateDefault();
            if (!StringUtils.isEmpty((Object)param.getName())) {
                app.setName(param.getName());
            }
            if (param.getRedirectUri() != null) {
                app.setRegisteredRedirectUri(param.getRedirectUri());
            }
            if (param.getScope() != null) {
                app.setScope(param.getScope());
            }
        });
        this.applicationService.updateClientDetails(application.get());
        return application.get();
    }

    @DeleteMapping(value={"${watchdog.application.prefix:}/applications/{clientId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable String clientId) {
        this.applicationService.removeClientDetails(clientId);
    }
}

