/*
 * Decompiled with CFR 0.152.
 */
package org.yuequan.watchdog.configuration;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.yuequan.watchdog.provider.WatchdogUrlRegistryProvider;

@EnableResourceServer
public class ResourceServerConfiguration
extends ResourceServerConfigurerAdapter
implements ApplicationContextAware {
    public static final String RESOURCE_NAME = "watchdog";
    private ApplicationContext applicationContext;

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.resourceId(RESOURCE_NAME).stateless(true);
    }

    public void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).and()).requestMatchers().anyRequest()).and().authorizeRequests().antMatchers(new String[]{"/oauth/**", "/applications", "/applications/**"})).permitAll().and()).csrf().disable()).authorizeRequests().anyRequest()).authenticated();
        this.registerWatchdogProvider(http.authorizeRequests());
    }

    private void registerWatchdogProvider(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests) {
        Map watchdogProviders = this.applicationContext.getBeansOfType(WatchdogUrlRegistryProvider.class);
        watchdogProviders.values().forEach(provider -> provider.configure(authorizeRequests));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

