/*
 * Decompiled with CFR 0.152.
 */
package org.yuequan.watchdog.configuration;

import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.yuequan.watchdog.provider.WatchdogUrlRegistryProvider;

@EnableResourceServer
public class ResourceServerConfiguration
extends ResourceServerConfigurerAdapter
implements ApplicationContextAware {
    public static final String RESOURCE_NAME = "watchdog";
    @Value(value="${watchdog.oauth2.protect.path:/api/**}")
    private Set<String> apiPrefPath;
    private ApplicationContext applicationContext;

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.resourceId(RESOURCE_NAME).stateless(true);
    }

    public void configure(HttpSecurity http) throws Exception {
        String[] needAuthenticationPaths = this.apiPrefPath.toArray(new String[this.apiPrefPath.size()]);
        this.apiPrefPath.add("/applications");
        this.apiPrefPath.add("/applications/**");
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).and()).requestMatchers().antMatchers(this.apiPrefPath.toArray(new String[this.apiPrefPath.size()]))).and().authorizeRequests().antMatchers(new String[]{"/oauth/**", "/applications", "/applications/**"})).permitAll().antMatchers(needAuthenticationPaths)).authenticated().and()).csrf().disable();
        this.registerWatchdogProvider(http.authorizeRequests());
    }

    private void registerWatchdogProvider(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests) {
        Map watchdogProviders = this.applicationContext.getBeansOfType(WatchdogUrlRegistryProvider.class);
        watchdogProviders.values().forEach(provider -> provider.configure(authorizeRequests));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

