/*
 * Decompiled with CFR 0.152.
 */
package org.yuequan.watchdog.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.yuequan.watchdog.client.Application;
import org.yuequan.watchdog.client.ApplicationRepository;

public class ApplicationService
implements ClientDetailsService,
ClientRegistrationService {
    @Autowired
    private ApplicationRepository<Application> applicationRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public ClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        Optional<Application> application = this.applicationRepository.findByClientId(clientId);
        if (!application.isPresent()) {
            throw new NoSuchClientException("No client with requested id: " + clientId);
        }
        return this.applicationRepository.findByClientId(clientId).get();
    }

    public void addClientDetails(ClientDetails clientDetails) throws ClientAlreadyExistsException {
        if (this.applicationRepository.findByClientId(clientDetails.getClientId()).isPresent()) {
            throw new ClientAlreadyExistsException("The client already exists");
        }
        this.applicationRepository.save(clientDetails);
    }

    public void updateClientDetails(ClientDetails clientDetails) throws NoSuchClientException {
        if (!this.applicationRepository.findByClientId(clientDetails.getClientId()).isPresent()) {
            throw new NoSuchClientException("Not Found The Client.");
        }
        this.applicationRepository.update(clientDetails);
    }

    public void updateClientSecret(String clientId, String secret) throws NoSuchClientException {
        Optional<Application> application = this.applicationRepository.findByClientId(clientId);
        if (!application.isPresent()) {
            throw new NoSuchClientException("Not Found The Client.");
        }
        application.get().setClientSecret(this.passwordEncoder.encode((CharSequence)secret));
        this.applicationRepository.update(application.get());
    }

    public void removeClientDetails(String clientId) throws NoSuchClientException {
        this.applicationRepository.delete(clientId);
    }

    public List<ClientDetails> listClientDetails() {
        ArrayList<ClientDetails> clientDetails = new ArrayList<ClientDetails>();
        this.applicationRepository.findAll().forEach(application -> clientDetails.add((ClientDetails)application));
        return clientDetails;
    }

    public List<Application> findAll() {
        return this.applicationRepository.findAll();
    }

    public Optional<Application> findByClientId(String clientId) {
        return this.applicationRepository.findByClientId(clientId);
    }
}

