/*
 * Decompiled with CFR 0.152.
 */
package org.yuequan.watchdog.client;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.util.DefaultJdbcListFactory;
import org.springframework.security.oauth2.common.util.JdbcListFactory;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.yuequan.watchdog.client.Application;
import org.yuequan.watchdog.client.ApplicationRepository;
import org.yuequan.watchdog.util.FieldUtil;

public class DefaultApplicationRepositoryImpl
implements ApplicationRepository<Application> {
    private final DataSource dataSource;
    private static final Log logger = LogFactory.getLog(DefaultApplicationRepositoryImpl.class);
    private static final String CLIENT_FIELDS_FOR_UPDATE = "resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret";
    private static final String CLIENT_FIELDS = "client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret";
    private static final String BASE_FIND_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret from oauth_client_details";
    private static final String DEFAULT_FIND_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret from oauth_client_details order by client_id";
    private static final String DEFAULT_SELECT_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret from oauth_client_details where client_id = ?";
    private static final String DEFAULT_INSERT_STATEMENT = "insert into oauth_client_details (client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret, client_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DEFAULT_UPDATE_STATEMENT = "update oauth_client_details set " + "resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret".replaceAll(", ", "=?, ") + "=? where client_id = ?";
    private static final String DEFAULT_UPDATE_SECRET_STATEMENT = "update oauth_client_details set client_secret = ? where client_id = ?";
    private static final String DEFAULT_DELETE_STATEMENT = "delete from oauth_client_details where client_id = ?";
    private String deleteApplicationSql = "delete from oauth_client_details where client_id = ?";
    private String findApplicationSql = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret from oauth_client_details order by client_id";
    private String updateApplicationSql = DEFAULT_UPDATE_STATEMENT;
    private String updateApplicationSecretSql = "update oauth_client_details set client_secret = ? where client_id = ?";
    private String insertApplicationSql = "insert into oauth_client_details (client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret, client_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private String selectApplicationSql = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, name, raw_client_secret from oauth_client_details where client_id = ?";
    private RowMapper<Application> rowMapper = new ApplicationRowMapper();
    private final JdbcTemplate jdbcTemplate;
    private final JdbcListFactory listFactory;
    private final PasswordEncoder passwordEncoder;

    public DefaultApplicationRepositoryImpl(DataSource dataSource, PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.listFactory = new DefaultJdbcListFactory((NamedParameterJdbcOperations)new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate));
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public Application save(ClientDetails application) {
        this.jdbcTemplate.update(this.insertApplicationSql, FieldUtil.getFields(application, this.passwordEncoder));
        return this.findByClientId(application.getClientId()).get();
    }

    @Override
    public Optional<Application> findByClientId(String clientId) {
        Application application;
        try {
            application = (Application)((Object)this.jdbcTemplate.queryForObject(this.selectApplicationSql, (RowMapper)new ApplicationRowMapper(), new Object[]{clientId}));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
        return Optional.ofNullable(application);
    }

    @Override
    public Application update(ClientDetails application) {
        int count = this.jdbcTemplate.update(this.updateApplicationSql, FieldUtil.getFieldsForUpdate(application));
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + application.getClientId());
        }
        return this.findByClientId(application.getClientId()).get();
    }

    @Override
    public List<Application> findAll() {
        return this.listFactory.getList(this.findApplicationSql, Collections.emptyMap(), this.rowMapper);
    }

    @Override
    public List<Application> findAll(int pageNo, int pageSize) {
        return null;
    }

    @Override
    public void delete(String clientId) {
        int count = this.jdbcTemplate.update(this.deleteApplicationSql, new Object[]{clientId});
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
    }

    private static class ApplicationRowMapper
    implements RowMapper<Application> {
        private FieldUtil.JsonMapper mapper = FieldUtil.createJsonMapper();

        private ApplicationRowMapper() {
        }

        public Application mapRow(ResultSet rs, int rowNum) throws SQLException {
            String scopes;
            String json;
            Application details = new Application(rs.getString(1), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(7), rs.getString(6));
            details.setClientSecret(rs.getString(2));
            if (rs.getObject(8) != null) {
                details.setAccessTokenValiditySeconds(rs.getInt(8));
            }
            if (rs.getObject(9) != null) {
                details.setRefreshTokenValiditySeconds(rs.getInt(9));
            }
            if ((json = rs.getString(10)) != null) {
                try {
                    Map additionalInformation = this.mapper.read(json, Map.class);
                    details.setAdditionalInformation(additionalInformation);
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not decode JSON for additional information: " + (Object)((Object)details)), (Throwable)e);
                }
            }
            if ((scopes = rs.getString(11)) != null) {
                details.setAutoApproveScopes(StringUtils.commaDelimitedListToSet((String)scopes));
            }
            details.setName(rs.getString(12));
            details.setRawClientSecret(rs.getString(13));
            return details;
        }
    }
}

