/*
 * Decompiled with CFR 0.152.
 */
package org.yuequan.watchdog.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.yuequan.watchdog.client.Application;

public final class FieldUtil {
    private static final JsonMapper mapper = FieldUtil.createJsonMapper();
    private static final Log logger = LogFactory.getLog(FieldUtil.class);

    public static <T extends ClientDetails> Object[] getFields(T clientDetails, PasswordEncoder passwordEncoder) {
        Object[] fieldsForUpdate = FieldUtil.getFieldsForUpdate(clientDetails);
        Object[] fields = new Object[fieldsForUpdate.length + 1];
        System.arraycopy(fieldsForUpdate, 0, fields, 1, fieldsForUpdate.length);
        fields[0] = clientDetails.getClientSecret() != null ? passwordEncoder.encode((CharSequence)clientDetails.getClientSecret()) : null;
        return fields;
    }

    public static <T extends ClientDetails> Object[] getFieldsForUpdate(T clientDetails) {
        String json = null;
        try {
            json = mapper.write(clientDetails.getAdditionalInformation());
        }
        catch (Exception e) {
            logger.warn((Object)("Could not serialize additional information: " + clientDetails), (Throwable)e);
        }
        if (clientDetails instanceof Application) {
            return new Object[]{clientDetails.getResourceIds() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getResourceIds()) : null, clientDetails.getScope() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getScope()) : null, clientDetails.getAuthorizedGrantTypes() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getAuthorizedGrantTypes()) : null, clientDetails.getRegisteredRedirectUri() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getRegisteredRedirectUri()) : null, clientDetails.getAuthorities() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getAuthorities()) : null, clientDetails.getAccessTokenValiditySeconds(), clientDetails.getRefreshTokenValiditySeconds(), json, FieldUtil.getAutoApproveScopes(clientDetails), ((Application)clientDetails).getName(), ((Application)clientDetails).getRawClientSecret(), clientDetails.getClientId()};
        }
        return new Object[]{clientDetails.getResourceIds() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getResourceIds()) : null, clientDetails.getScope() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getScope()) : null, clientDetails.getAuthorizedGrantTypes() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getAuthorizedGrantTypes()) : null, clientDetails.getRegisteredRedirectUri() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getRegisteredRedirectUri()) : null, clientDetails.getAuthorities() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getAuthorities()) : null, clientDetails.getAccessTokenValiditySeconds(), clientDetails.getRefreshTokenValiditySeconds(), json, FieldUtil.getAutoApproveScopes(clientDetails), clientDetails.getClientId()};
    }

    public static String getAutoApproveScopes(ClientDetails clientDetails) {
        if (clientDetails.isAutoApprove("true")) {
            return "true";
        }
        HashSet<String> scopes = new HashSet<String>();
        for (String scope : clientDetails.getScope()) {
            if (!clientDetails.isAutoApprove(scope)) continue;
            scopes.add(scope);
        }
        return StringUtils.collectionToCommaDelimitedString(scopes);
    }

    public static JsonMapper createJsonMapper() {
        if (ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", null)) {
            return new JacksonMapper();
        }
        if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null)) {
            return new Jackson2Mapper();
        }
        return new NotSupportedJsonMapper();
    }

    public static class NotSupportedJsonMapper
    implements JsonMapper {
        @Override
        public String write(Object input) throws Exception {
            throw new UnsupportedOperationException("Neither Jackson 1 nor 2 is available so JSON conversion cannot be done");
        }

        @Override
        public <T> T read(String input, Class<T> type) throws Exception {
            throw new UnsupportedOperationException("Neither Jackson 1 nor 2 is available so JSON conversion cannot be done");
        }
    }

    public static class Jackson2Mapper
    implements JsonMapper {
        private ObjectMapper mapper = new ObjectMapper();

        @Override
        public String write(Object input) throws Exception {
            return this.mapper.writeValueAsString(input);
        }

        @Override
        public <T> T read(String input, Class<T> type) throws Exception {
            return (T)this.mapper.readValue(input, type);
        }
    }

    public static class JacksonMapper
    implements JsonMapper {
        private org.codehaus.jackson.map.ObjectMapper mapper = new org.codehaus.jackson.map.ObjectMapper();

        @Override
        public String write(Object input) throws Exception {
            return this.mapper.writeValueAsString(input);
        }

        @Override
        public <T> T read(String input, Class<T> type) throws Exception {
            return (T)this.mapper.readValue(input, type);
        }
    }

    public static interface JsonMapper {
        public String write(Object var1) throws Exception;

        public <T> T read(String var1, Class<T> var2) throws Exception;
    }
}

