package org.zalando.emsig;

import org.zalando.emsig.exception.InvalidSignatureException;
import org.zalando.emsig.exception.MissingSignatureException;
import org.zalando.emsig.exception.SignatureException;
import org.zalando.emsig.model.Signable;

public interface SignatureValidator {
    /**
     * Validates the signature of an object.
     * Throws exceptions if the signature is invalid or missing and returns normally if the signature is valid.
     *
     * @param signable the object to be signed
     * @throws InvalidSignatureException
     * @throws MissingSignatureException
     * @throws SignatureException
     */
    void validate(Signable signable) throws SignatureException;
}
