package org.zalando.emsig;

import org.zalando.emsig.model.Signable;
import org.zalando.emsig.model.Signature;

public interface Signer {
    /**
     * - empty arrays are signed
     * - property order alphabetic
     * - 2 fraction digits
     * - no pretty printing
     * - signature lower case hex string
     *
     *
     * @param signable the object to be signed
     * @return a signature
     * @see <a href="https://tools.ietf.org/html/draft-staykov-hu-json-canonical-form-00">JSON Canonical Form</a>
     */
    Signature sign(Signable signable);

}
