package org.zalando.emsig.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Objects;

@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class Signature {

    private final String value;

    @JsonCreator
    public Signature(@JsonProperty("value") final String value) {
        this.value = value;
    }

    @NotNull
    @Size(min = 1)
    public String getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(final Object that) {
        if (this == that) {
            return true;
        } else if (that instanceof Signature) {
            final Signature other = (Signature) that;
            return Objects.equals(value, other.value);
        } else {
            return false;
        }
    }

    @Override
    public String toString() {
        return value;
    }

}
