package org.zalando.emsig.validation;

import org.zalando.emsig.SignatureValidator;
import org.zalando.emsig.exception.InvalidSignatureException;
import org.zalando.emsig.exception.SignatureException;
import org.zalando.emsig.model.Signable;

import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class SignedConstraintValidator implements ConstraintValidator<ValidSignature, Signable> {

    private final SignatureValidator signatureValidator;

    @Inject
    public SignedConstraintValidator(final SignatureValidator signatureValidator) {
        this.signatureValidator = signatureValidator;
    }

    @Override
    public void initialize(final ValidSignature annotation) {

    }

    @Override
    public boolean isValid(final Signable signable, final ConstraintValidatorContext context) {
        try {
            signatureValidator.validate(signable);
            return true;
        } catch (InvalidSignatureException e) {
            reportViolation(context, "signature", "value");
            return false;
        } catch (SignatureException e) {
            reportViolation(context, "signature");
            return false;
        }
    }

    private static void reportViolation(final ConstraintValidatorContext context, final String property, final String... nestedProperties) {
        context.disableDefaultConstraintViolation();
        final String template = context.getDefaultConstraintMessageTemplate();
        final ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(template);
        ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext nodeContext = builder.addPropertyNode(property);

        for (String nestedProperty : nestedProperties) {
            nodeContext = nodeContext.addPropertyNode(nestedProperty);
        }

        nodeContext.addConstraintViolation();
    }
}
