package org.zalando.emsig.validation;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Documented
@Constraint(validatedBy = SignedConstraintValidator.class)
@Target(TYPE)
@Retention(RUNTIME)
public @interface ValidSignature {

    String message() default "must match signed properties";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
