/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.inmemory;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.domain.Cursor;

public final class InMemoryCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryCursorManager.class);
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Cursor>> partitionsByEventName = new ConcurrentHashMap();

    private ConcurrentHashMap<String, Cursor> cursorsByPartition(String eventName) {
        return this.partitionsByEventName.computeIfAbsent(eventName, key -> new ConcurrentHashMap());
    }

    public void onSuccess(String eventName, Cursor cursor) {
        this.cursorsByPartition(eventName).put(cursor.getPartition(), cursor);
    }

    public void onSuccess(String eventName, List<Cursor> cursors) throws IOException {
        for (Cursor cursor : cursors) {
            this.onSuccess(eventName, cursor);
        }
    }

    public Collection<Cursor> getCursors(String eventName) {
        return Collections.unmodifiableCollection(this.cursorsByPartition(eventName).values());
    }
}

