/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.inmemory;

import java.util.concurrent.ConcurrentHashMap;
import org.zalando.fahrschein.SimplePartitionManager;

public class InMemoryPartitionManager
extends SimplePartitionManager {
    private final ConcurrentHashMap<String, String> locks = new ConcurrentHashMap();

    protected boolean acquireLock(String eventName, String lockedBy) {
        String newLockedBy = this.locks.compute(eventName, (key, oldLockedBy) -> oldLockedBy == null || oldLockedBy.equals(lockedBy) ? lockedBy : oldLockedBy);
        return lockedBy.equals(newLockedBy);
    }

    protected void releaseLock(String eventName, String lockedBy) {
        String newLockedBy = this.locks.compute(eventName, (key, oldLockedBy) -> oldLockedBy != null && oldLockedBy.equals(lockedBy) ? null : oldLockedBy);
        if (newLockedBy != null) {
            throw new IllegalStateException("Could not unlock [" + eventName + "] by [" + lockedBy + "] because it is locked by [" + newLockedBy + "]");
        }
    }
}

