/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.jdbc;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.domain.Cursor;

public class JdbcCursorManager
implements CursorManager {
    private static final String FIND_BY_EVENT_NAME = "SELECT * FROM %snakadi_cursor_find_by_event_name(?, ?)";
    private static final String UPDATE = "SELECT * FROM %snakadi_cursor_update(?, ?, ?, ?)";
    private final JdbcTemplate template;
    private final String consumerName;
    private final String schemaPrefix;

    public JdbcCursorManager(JdbcTemplate template, String consumerName, String schema) {
        Preconditions.checkState((schema != null && !schema.isEmpty() ? 1 : 0) != 0, (Object)"Schema name should not be null or empty");
        this.template = template;
        this.consumerName = consumerName;
        this.schemaPrefix = schema + ".";
    }

    public JdbcCursorManager(JdbcTemplate template, String consumerName) {
        this.template = template;
        this.consumerName = consumerName;
        this.schemaPrefix = "";
    }

    public JdbcCursorManager(DataSource dataSource, String consumerName, String schema) {
        this(new JdbcTemplate(dataSource), consumerName, schema);
    }

    public JdbcCursorManager(DataSource dataSource, String consumerName) {
        this(new JdbcTemplate(dataSource), consumerName);
    }

    @Transactional
    public void onSuccess(String eventName, Cursor cursor) throws IOException {
        String sql = String.format(UPDATE, this.schemaPrefix);
        Object[] params = this.mapParams(eventName, cursor);
        this.template.queryForObject(sql, params, Integer.class);
    }

    @Transactional
    public void onSuccess(String eventName, List<Cursor> cursors) throws IOException {
        String sql = String.format(UPDATE, this.schemaPrefix);
        List params = cursors.stream().map(c -> this.mapParams(eventName, (Cursor)c)).collect(Collectors.toList());
        this.template.batchUpdate(sql, params);
    }

    private Object[] mapParams(String eventName, Cursor cursor) {
        return new Object[]{this.consumerName, eventName, cursor.getPartition(), cursor.getOffset()};
    }

    public Collection<Cursor> getCursors(String eventName) throws IOException {
        String sql = String.format(FIND_BY_EVENT_NAME, this.schemaPrefix);
        return this.template.query(sql, new Object[]{this.consumerName, eventName}, (resultSet, i) -> {
            String partition = resultSet.getString(2);
            String offset = resultSet.getString(3);
            return new Cursor(partition, offset);
        });
    }
}

