/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.zalando.fahrschein.MetricsCollector;

public class DropwizardMetricsCollector
implements MetricsCollector {
    public static final String DEFAULT_PREFIX = "org.zalando.fahrschein.";
    private final Meter messagesReceivedMeter;
    private final Meter eventsReceivedMeter;
    private final Meter errorsWhileConsumingMeter;
    private final Meter reconnectionsMeter;
    private final Meter messagesSuccessfullyProcessedMeter;

    public DropwizardMetricsCollector(MetricRegistry metricRegistry) {
        this(metricRegistry, DEFAULT_PREFIX);
    }

    public DropwizardMetricsCollector(MetricRegistry metricRegistry, String prefix) {
        this.messagesReceivedMeter = metricRegistry.meter(prefix + "messagesReceived");
        this.eventsReceivedMeter = metricRegistry.meter(prefix + "eventsReceived");
        this.errorsWhileConsumingMeter = metricRegistry.meter(prefix + "errorsWhileConsuming");
        this.reconnectionsMeter = metricRegistry.meter(prefix + "reconnections");
        this.messagesSuccessfullyProcessedMeter = metricRegistry.meter(prefix + "messagesSuccessfullyProcessed");
    }

    public void markMessageReceived() {
        this.messagesReceivedMeter.mark();
    }

    public void markEventsReceived(int size) {
        this.eventsReceivedMeter.mark((long)size);
    }

    public void markErrorWhileConsuming() {
        this.errorsWhileConsumingMeter.mark();
    }

    public void markReconnection() {
        this.reconnectionsMeter.mark();
    }

    public void markMessageSuccessfullyProcessed() {
        this.messagesSuccessfullyProcessedMeter.mark();
    }
}

