/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.function.LongSupplier;
import org.zalando.fahrschein.MetricsCollector;

class LastActivityMetricsCollector
implements MetricsCollector {
    private long lastMessageReceived = 0L;
    private long lastMessageSuccessfullyProcessed = 0L;
    private long lastEventReceived = 0L;
    private long lastErrorHappend = 0L;
    private long lastReconnect = 0L;

    public LastActivityMetricsCollector(MetricRegistry metricRegistry, String metricsNamePrefix) {
        this.createOrReplaceGauge(metricRegistry, MetricRegistry.name((String)metricsNamePrefix, (String[])new String[]{"lastMessageReceived"}), () -> (System.currentTimeMillis() - this.lastMessageReceived) / 1000L);
        this.createOrReplaceGauge(metricRegistry, MetricRegistry.name((String)metricsNamePrefix, (String[])new String[]{"lastMessageSuccessfullyProcessed"}), () -> (System.currentTimeMillis() - this.lastMessageSuccessfullyProcessed) / 1000L);
        this.createOrReplaceGauge(metricRegistry, MetricRegistry.name((String)metricsNamePrefix, (String[])new String[]{"lastEventReceived"}), () -> (System.currentTimeMillis() - this.lastEventReceived) / 1000L);
        this.createOrReplaceGauge(metricRegistry, MetricRegistry.name((String)metricsNamePrefix, (String[])new String[]{"lastErrorHappened"}), () -> (System.currentTimeMillis() - this.lastErrorHappend) / 1000L);
        this.createOrReplaceGauge(metricRegistry, MetricRegistry.name((String)metricsNamePrefix, (String[])new String[]{"lastReconnect"}), () -> (System.currentTimeMillis() - this.lastReconnect) / 1000L);
    }

    private void createOrReplaceGauge(MetricRegistry metricRegistry, String gaugeName, LongSupplier gaugeValueSupplier) {
        metricRegistry.remove(gaugeName);
        metricRegistry.register(gaugeName, (Metric)((Gauge)() -> (int)gaugeValueSupplier.getAsLong()));
    }

    public void markMessageReceived() {
        this.lastMessageReceived = System.currentTimeMillis();
    }

    public void markEventsReceived(int size) {
        this.lastEventReceived = System.currentTimeMillis();
    }

    public void markErrorWhileConsuming() {
        this.lastErrorHappend = System.currentTimeMillis();
    }

    public void markReconnection() {
        this.lastReconnect = System.currentTimeMillis();
    }

    public void markMessageSuccessfullyProcessed() {
        this.lastMessageSuccessfullyProcessed = System.currentTimeMillis();
    }
}

