/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.metrics.dropwizard;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.zalando.fahrschein.MetricsCollector;

class CountingMetricsCollector
implements MetricsCollector {
    private final Meter messagesReceivedMeter;
    private final Meter eventsReceivedMeter;
    private final Meter errorsWhileConsumingMeter;
    private final Meter reconnectionsMeter;
    private final Meter messagesSuccessfullyProcessedMeter;

    public CountingMetricsCollector(MetricRegistry metricRegistry, String prefix) {
        this.messagesReceivedMeter = metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"messagesReceived"}));
        this.eventsReceivedMeter = metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"eventsReceived"}));
        this.errorsWhileConsumingMeter = metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"errorsWhileConsuming"}));
        this.reconnectionsMeter = metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"reconnections"}));
        this.messagesSuccessfullyProcessedMeter = metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{"messagesSuccessfullyProcessed"}));
    }

    public void markMessageReceived() {
        this.messagesReceivedMeter.mark();
    }

    public void markEventsReceived(int size) {
        this.eventsReceivedMeter.mark((long)size);
    }

    public void markErrorWhileConsuming() {
        this.errorsWhileConsumingMeter.mark();
    }

    public void markReconnection() {
        this.reconnectionsMeter.mark();
    }

    public void markMessageSuccessfullyProcessed() {
        this.messagesSuccessfullyProcessedMeter.mark();
    }
}

