/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import org.zalando.fahrschein.MetricsCollector;
import org.zalando.fahrschein.metrics.micrometer.MicrometerMetricsCollector;

class CountingMetricsCollector
implements MetricsCollector {
    private final Counter messagesReceivedMeter;
    private final Counter eventsReceivedMeter;
    private final Counter errorsWhileConsumingMeter;
    private final Counter reconnectionsMeter;
    private final Counter messagesSuccessfullyProcessedMeter;

    CountingMetricsCollector(MeterRegistry metricRegistry, String prefix) {
        this.messagesReceivedMeter = metricRegistry.counter(MicrometerMetricsCollector.name(prefix, "messages", "received"), new String[0]);
        this.eventsReceivedMeter = metricRegistry.counter(MicrometerMetricsCollector.name(prefix, "events", "received"), new String[0]);
        this.errorsWhileConsumingMeter = metricRegistry.counter(MicrometerMetricsCollector.name(prefix, "errors", "while", "consuming"), new String[0]);
        this.reconnectionsMeter = metricRegistry.counter(MicrometerMetricsCollector.name(prefix, "reconnections"), new String[0]);
        this.messagesSuccessfullyProcessedMeter = metricRegistry.counter(MicrometerMetricsCollector.name(prefix, "messages", "successfully", "processed"), new String[0]);
    }

    public void markMessageReceived() {
        this.messagesReceivedMeter.increment();
    }

    public void markEventsReceived(int size) {
        this.eventsReceivedMeter.increment((double)size);
    }

    public void markErrorWhileConsuming() {
        this.errorsWhileConsumingMeter.increment();
    }

    public void markReconnection() {
        this.reconnectionsMeter.increment();
    }

    public void markMessageSuccessfullyProcessed() {
        this.messagesSuccessfullyProcessedMeter.increment();
    }
}

