/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.metrics.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import java.util.concurrent.TimeUnit;
import org.zalando.fahrschein.MetricsCollector;
import org.zalando.fahrschein.metrics.micrometer.MicrometerMetricsCollector;

class LastActivityMetricsCollector
implements MetricsCollector {
    private long lastMessageReceived = 0L;
    private long lastMessageSuccessfullyProcessed = 0L;
    private long lastEventReceived = 0L;
    private long lastErrorHappened = 0L;
    private long lastReconnect = 0L;
    final Clock clock;

    LastActivityMetricsCollector(MeterRegistry metricRegistry, String metricsNamePrefix) {
        this.clock = metricRegistry.config().clock();
        TimeGauge.builder((String)MicrometerMetricsCollector.name(metricsNamePrefix, "last", "message", "received"), () -> (int)((this.clock.wallTime() - this.lastMessageReceived) / 1000L), (TimeUnit)TimeUnit.SECONDS).register(metricRegistry);
        TimeGauge.builder((String)MicrometerMetricsCollector.name(metricsNamePrefix, "last", "message", "successfully", "processed"), () -> (int)((this.clock.wallTime() - this.lastMessageSuccessfullyProcessed) / 1000L), (TimeUnit)TimeUnit.SECONDS).register(metricRegistry);
        TimeGauge.builder((String)MicrometerMetricsCollector.name(metricsNamePrefix, "last", "event", "received"), () -> (int)((this.clock.wallTime() - this.lastEventReceived) / 1000L), (TimeUnit)TimeUnit.SECONDS).register(metricRegistry);
        TimeGauge.builder((String)MicrometerMetricsCollector.name(metricsNamePrefix, "last", "error", "happened"), () -> (int)((this.clock.wallTime() - this.lastErrorHappened) / 1000L), (TimeUnit)TimeUnit.SECONDS).register(metricRegistry);
        TimeGauge.builder((String)MicrometerMetricsCollector.name(metricsNamePrefix, "last", "reconnect"), () -> (int)((this.clock.wallTime() - this.lastReconnect) / 1000L), (TimeUnit)TimeUnit.SECONDS).register(metricRegistry);
    }

    public void markMessageReceived() {
        this.lastMessageReceived = this.clock.wallTime();
    }

    public void markEventsReceived(int size) {
        this.lastEventReceived = this.clock.wallTime();
    }

    public void markErrorWhileConsuming() {
        this.lastErrorHappened = this.clock.wallTime();
    }

    public void markReconnection() {
        this.lastReconnect = this.clock.wallTime();
    }

    public void markMessageSuccessfullyProcessed() {
        this.lastMessageSuccessfullyProcessed = this.clock.wallTime();
    }
}

