/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.redis;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;

class Codec {
    private static final char DELIMITER_CHAR = '\u0000';
    private static final String DELIMITER_STRING = String.valueOf('\u0000');
    private static final Charset UTF8 = Charset.forName("UTF-8");

    Codec() {
    }

    public byte[] serialize(String ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append('\u0000');
        }
        return sb.toString().getBytes(UTF8);
    }

    public String[] deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(new String(bytes, UTF8), DELIMITER_STRING);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result.toArray(new String[result.size()]);
    }
}

