/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.domain.Cursor;

@Transactional
public abstract class AbstractCursorManagerTest {
    protected abstract CursorManager cursorManager();

    @Test
    public void shouldBeEmptyByDefault() throws IOException {
        Collection cursors = this.cursorManager().getCursors("test");
        Assert.assertNotNull((Object)cursors);
        Assert.assertTrue((boolean)cursors.isEmpty());
    }

    @Test
    public void shouldCreateCursorOnSuccess() throws IOException {
        this.cursorManager().onSuccess("test", new Cursor("0", "123"));
        Collection cursors = this.cursorManager().getCursors("test");
        Assert.assertNotNull((Object)cursors);
        Assert.assertEquals((long)1L, (long)cursors.size());
        Cursor cursor = (Cursor)cursors.iterator().next();
        Assert.assertEquals((Object)"0", (Object)cursor.getPartition());
        Assert.assertEquals((Object)"123", (Object)cursor.getOffset());
    }

    @Test
    public void shouldUpdateCursorOnSuccess() throws IOException {
        this.cursorManager().onSuccess("test", new Cursor("0", "123"));
        Collection cursors = this.cursorManager().getCursors("test");
        Assert.assertNotNull((Object)cursors);
        Assert.assertEquals((long)1L, (long)cursors.size());
        Cursor cursor = (Cursor)cursors.iterator().next();
        Assert.assertEquals((Object)"0", (Object)cursor.getPartition());
        Assert.assertEquals((Object)"123", (Object)cursor.getOffset());
        this.cursorManager().onSuccess("test", new Cursor("0", "124"));
        cursors = this.cursorManager().getCursors("test");
        Assert.assertNotNull((Object)cursors);
        Assert.assertEquals((long)1L, (long)cursors.size());
        cursor = (Cursor)cursors.iterator().next();
        Assert.assertEquals((Object)"0", (Object)cursor.getPartition());
        Assert.assertEquals((Object)"124", (Object)cursor.getOffset());
    }

    @Test
    public void shouldCreateCursorsForMultiplePartitions() throws IOException {
        this.cursorManager().onSuccess("test", new Cursor("0", "12"));
        this.cursorManager().onSuccess("test", new Cursor("1", "13"));
        ArrayList cursors = new ArrayList(this.cursorManager().getCursors("test"));
        Collections.sort(cursors, Comparator.comparing(Cursor::getPartition));
        Assert.assertNotNull(cursors);
        Assert.assertEquals((long)2L, (long)cursors.size());
        Cursor cursor = (Cursor)cursors.get(0);
        Assert.assertEquals((Object)"0", (Object)cursor.getPartition());
        Assert.assertEquals((Object)"12", (Object)cursor.getOffset());
        cursor = (Cursor)cursors.get(1);
        Assert.assertEquals((Object)"1", (Object)cursor.getPartition());
        Assert.assertEquals((Object)"13", (Object)cursor.getOffset());
    }
}

