/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.test;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.fahrschein.PartitionManager;
import org.zalando.fahrschein.domain.Lock;
import org.zalando.fahrschein.domain.Partition;

@Transactional
public abstract class AbstractPartitionManagerTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    protected abstract PartitionManager partitionManager();

    protected abstract PartitionManager partitionManagerForAnotherConsumer();

    protected List<Partition> partitions(String ... ids) {
        return Arrays.stream(ids).map(id -> new Partition(id, "0", "0")).collect(Collectors.toList());
    }

    @Test
    public void shouldLock() {
        Optional locked = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked.isPresent());
    }

    @Test
    public void shouldAllowLockBySameNode() {
        Optional locked1 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked1.isPresent());
        Optional locked2 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked2.isPresent());
    }

    @Test
    public void shouldNotLockAlreadyLocked() {
        Optional locked1 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked1.isPresent());
        Optional locked2 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-2");
        Assert.assertFalse((boolean)locked2.isPresent());
    }

    @Test
    public void shouldLockIndependentConsumers() {
        Optional locked1 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "consumer-1-node-1");
        Assert.assertTrue((boolean)locked1.isPresent());
        Optional locked2 = this.partitionManagerForAnotherConsumer().lockPartitions("sales-order-placed", this.partitions("0"), "consumer-2-node-1");
        Assert.assertTrue((boolean)locked2.isPresent());
    }

    @Test
    public void shouldLockIndependentEvents() {
        Optional locked1 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked1.isPresent());
        Optional locked2 = this.partitionManager().lockPartitions("address-changed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked2.isPresent());
    }

    @Test
    public void shouldLockIndependentPartitions() {
        Optional locked1 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked1.isPresent());
        Optional locked2 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("1"), "node-1");
        Assert.assertTrue((boolean)locked2.isPresent());
    }

    @Test
    public void shouldUnlock() throws InterruptedException {
        Optional locked1 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked1.isPresent());
        this.partitionManager().unlockPartitions((Lock)locked1.get());
        Optional locked2 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-2");
        Assert.assertTrue((boolean)locked2.isPresent());
    }

    @Test
    public void shouldFailOnInvalidUnlock() throws InterruptedException {
        Optional locked1 = this.partitionManager().lockPartitions("sales-order-placed", this.partitions("0"), "node-1");
        Assert.assertTrue((boolean)locked1.isPresent());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Could not unlock");
        this.partitionManager().unlockPartitions(new Lock("sales-order-placed", "node-2", this.partitions("0")));
    }
}

