/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.ExponentialBackoffException;
import org.zalando.fahrschein.IOCallable;

public class ExponentialBackoffStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialBackoffStrategy.class);
    public static final int DEFAULT_INITIAL_DELAY = 500;
    public static final double DEFAULT_BACKOFF_FACTOR = 1.5;
    public static final long DEFAULT_MAX_DELAY = 600000L;
    private final int initialDelay;
    private final double backoffFactor;
    private final long maxDelay;
    private final int maxRetries;

    public ExponentialBackoffStrategy() {
        this(500, 1.5, 600000L, -1);
    }

    public ExponentialBackoffStrategy(int initialDelay, double backoffFactor, long maxDelay, int maxRetries) {
        this.initialDelay = initialDelay;
        this.backoffFactor = backoffFactor;
        this.maxDelay = maxDelay;
        this.maxRetries = maxRetries;
    }

    private long calculateDelay(double count) {
        return Math.min((long)((double)this.initialDelay * Math.pow(this.backoffFactor, count)), this.maxDelay);
    }

    private void sleepForRetries(int count) throws InterruptedException {
        long delay = this.calculateDelay(count);
        LOG.info("Retry [{}], sleeping for [{}] milliseconds", (Object)count, (Object)delay);
        Thread.sleep(delay);
    }

    public <T> T call(IOCallable<T> callable) throws ExponentialBackoffException, InterruptedException {
        return this.call(0, callable);
    }

    public <T> T call(int initialCount, IOCallable<T> callable) throws ExponentialBackoffException, InterruptedException {
        int count = initialCount;
        if (count > 0) {
            this.sleepForRetries(count);
        }
        while (true) {
            try {
                LOG.trace("Try [{}]", (Object)count);
                return callable.call();
            }
            catch (IOException e) {
                LOG.warn("Got [{}]", (Object)e.getClass().getSimpleName(), (Object)e);
                if (this.maxRetries >= 0 && ++count > this.maxRetries) {
                    LOG.info("Maximum number of retries exceeded");
                    throw new ExponentialBackoffException(e);
                }
                this.sleepForRetries(count);
                continue;
            }
            break;
        }
    }
}

