/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.zalando.problem.Problem;

public class IOProblem
extends IOException
implements Problem {
    private final URI type;
    private final String title;
    private final Response.StatusType status;
    private final Optional<String> detail;
    private final Optional<URI> instance;

    @JsonCreator
    public IOProblem(@JsonProperty(value="type") URI type, @JsonProperty(value="title") String title, @JsonProperty(value="status") int status, @JsonProperty(value="detail") Optional<String> detail, @JsonProperty(value="instance") Optional<URI> instance) {
        super(IOProblem.formatMessage(type, title, status));
        this.type = type;
        this.title = title;
        this.status = Response.Status.fromStatusCode((int)status);
        this.detail = detail;
        this.instance = instance;
    }

    public IOProblem(URI type, String title, int status) {
        this(type, title, status, Optional.empty(), Optional.empty());
    }

    private static String formatMessage(URI type, String title, int status) {
        return String.format("Problem [%s]: Status %d [%s]", type, status, title);
    }

    public URI getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public Response.StatusType getStatus() {
        return this.status;
    }

    public Optional<String> getDetail() {
        return this.detail;
    }

    public Optional<URI> getInstance() {
        return this.instance;
    }
}

