/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.domain.Cursor;

public class InMemoryCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryCursorManager.class);
    private final Map<String, Map<String, Cursor>> partitionsByEventName = new HashMap<String, Map<String, Cursor>>();

    @Override
    public void onSuccess(String eventName, Cursor cursor) {
        this.partitionsByEventName.computeIfAbsent(eventName, key -> new HashMap()).put(cursor.getPartition(), cursor);
    }

    @Override
    public void onError(String eventName, Cursor cursor, Throwable throwable) {
        LOG.warn("Exception while processing events for [{}] on partition [{}] at offset [{}]", new Object[]{eventName, cursor.getPartition(), cursor.getOffset(), throwable});
    }

    @Override
    public Collection<Cursor> getCursors(String eventName) {
        return Collections.unmodifiableCollection(this.partitionsByEventName.get(eventName).values());
    }
}

