/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.domain.Cursor;

public class PersistentCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentCursorManager.class);
    private final JdbcTemplate template;
    private final String update;
    private final String select;

    public PersistentCursorManager(JdbcTemplate template) throws IOException {
        this.template = template;
        this.update = PersistentCursorManager.readResource("update_cursor.sql");
        this.select = PersistentCursorManager.readResource("select_cursors_by_event_name.sql");
    }

    private static String readResource(String resourceName) throws IOException {
        return Resources.toString((URL)Resources.getResource(PersistentCursorManager.class, (String)resourceName), (Charset)StandardCharsets.UTF_8);
    }

    public PersistentCursorManager(DataSource dataSource) throws IOException {
        this(new JdbcTemplate(dataSource));
    }

    @Override
    public void onSuccess(String eventName, Cursor cursor) throws IOException {
        try {
            this.template.update(this.update, new Object[]{eventName, cursor.getPartition(), cursor.getOffset()});
        }
        catch (DataAccessException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void onError(String eventName, Cursor cursor, Throwable throwable) {
        LOG.warn("Exception while processing events for [{}] on partition [{}] at offset [{}]", new Object[]{eventName, cursor.getPartition(), cursor.getOffset(), throwable});
    }

    @Override
    public Collection<Cursor> getCursors(String eventName) throws IOException {
        try {
            return this.template.query(this.select, new Object[]{eventName}, (resultSet, i) -> new Cursor(resultSet.getString(2), resultSet.getString(3)));
        }
        catch (DataAccessException e) {
            throw new IOException(e);
        }
    }
}

