/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fahrschein.IOProblem;

public class ProblemHandlingClientHttpRequest
implements ClientHttpRequest {
    private static final Set<String> PROBLEM_CONTENT_TYPES = new HashSet<String>(Arrays.asList("application/json", "application/problem+json"));
    private static final URI DEFAULT_PROBLEM_TYPE = URI.create("about:blank");
    private final ClientHttpRequest clientHttpRequest;
    private final ObjectMapper objectMapper;

    public ProblemHandlingClientHttpRequest(ClientHttpRequest clientHttpRequest, ObjectMapper objectMapper) {
        this.clientHttpRequest = clientHttpRequest;
        this.objectMapper = objectMapper;
    }

    public ClientHttpResponse execute() throws IOException {
        ClientHttpResponse response = this.clientHttpRequest.execute();
        HttpStatus statusCode = response.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            MediaType contentType = response.getHeaders().getContentType();
            if (contentType != null && PROBLEM_CONTENT_TYPES.contains(contentType.getType())) {
                InputStream is = response.getBody();
                Throwable throwable = null;
                try {
                    try {
                        IOProblem problem = (IOProblem)this.objectMapper.readValue(is, IOProblem.class);
                        if (problem != null) {
                            throw problem;
                        }
                        throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusCode.getReasonPhrase(), statusCode.value());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            is.close();
                        }
                    }
                    throw throwable3;
                }
            }
            throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusCode.getReasonPhrase(), statusCode.value());
        }
        return response;
    }

    public HttpMethod getMethod() {
        return this.clientHttpRequest.getMethod();
    }

    public URI getURI() {
        return this.clientHttpRequest.getURI();
    }

    public HttpHeaders getHeaders() {
        return this.clientHttpRequest.getHeaders();
    }

    public OutputStream getBody() throws IOException {
        return this.clientHttpRequest.getBody();
    }
}

