/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.AccessTokenProvider;

public class ZignAccessTokenProvider
implements AccessTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ZignAccessTokenProvider.class);
    private LoadingCache<String, String> zignCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return ZignAccessTokenProvider.zign();
        }
    });

    private static String zign() throws IOException {
        LOG.info("Refreshing token from zign...");
        Process zign = new ProcessBuilder("zign", "token", "uid").start();
        try (InputStream inputStream = zign.getInputStream();){
            String string = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8)).trim();
            return string;
        }
    }

    @Override
    public String getAccessToken() throws IOException {
        try {
            return (String)this.zignCache.get((Object)"");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)cause, IOException.class);
            throw Throwables.propagate((Throwable)cause);
        }
    }
}

