/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.zalando.fahrschein.AccessTokenProvider;

class AuthorizedClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory delegate;
    private final AccessTokenProvider accessTokenProvider;

    public AuthorizedClientHttpRequestFactory(ClientHttpRequestFactory delegate, AccessTokenProvider accessTokenProvider) {
        this.delegate = delegate;
        this.accessTokenProvider = accessTokenProvider;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        ClientHttpRequest request = this.delegate.createRequest(uri, httpMethod);
        request.getHeaders().put("Authorization", Collections.singletonList("Bearer ".concat(this.accessTokenProvider.getAccessToken())));
        return request;
    }
}

