/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.AuthorizedClientHttpRequestFactory;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.ManagedCursorManager;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.ProblemHandlingClientHttpRequestFactory;
import org.zalando.fahrschein.http.simple.SimpleClientHttpRequestFactory;

public final class NakadiClientBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT = 500;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    private final URI baseUri;
    @Nullable
    private final ObjectMapper objectMapper;
    @Nullable
    private final AccessTokenProvider accessTokenProvider;
    @Nullable
    private final ClientHttpRequestFactory clientHttpRequestFactory;
    @Nullable
    private final CursorManager cursorManager;

    NakadiClientBuilder(URI baseUri) {
        this(baseUri, DefaultObjectMapper.INSTANCE, null, null, null);
    }

    private NakadiClientBuilder(URI baseUri, @Nullable ObjectMapper objectMapper, @Nullable AccessTokenProvider accessTokenProvider, @Nullable ClientHttpRequestFactory clientHttpRequestFactory, @Nullable CursorManager cursorManager) {
        this.objectMapper = objectMapper;
        this.baseUri = Preconditions.checkNotNull(baseUri, "Base URI should not be null");
        this.accessTokenProvider = accessTokenProvider;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.cursorManager = cursorManager;
    }

    public NakadiClientBuilder withObjectMapper(ObjectMapper objectMapper) {
        return new NakadiClientBuilder(this.baseUri, objectMapper, this.accessTokenProvider, this.clientHttpRequestFactory, this.cursorManager);
    }

    public NakadiClientBuilder withAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, accessTokenProvider, this.clientHttpRequestFactory, this.cursorManager);
    }

    public NakadiClientBuilder withClientHttpRequestFactory(ClientHttpRequestFactory clientHttpRequestFactory) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.accessTokenProvider, clientHttpRequestFactory, this.cursorManager);
    }

    public NakadiClientBuilder withCursorManager(CursorManager cursorManager) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.accessTokenProvider, this.clientHttpRequestFactory, cursorManager);
    }

    private ClientHttpRequestFactory defaultClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(500);
        clientHttpRequestFactory.setReadTimeout(60000);
        return clientHttpRequestFactory;
    }

    private ClientHttpRequestFactory wrapClientHttpRequestFactory(ClientHttpRequestFactory delegate) {
        Object requestFactory = new ProblemHandlingClientHttpRequestFactory(delegate);
        if (this.accessTokenProvider != null) {
            requestFactory = new AuthorizedClientHttpRequestFactory((ClientHttpRequestFactory)requestFactory, this.accessTokenProvider);
        }
        return requestFactory;
    }

    public NakadiClient build() {
        ClientHttpRequestFactory clientHttpRequestFactory = this.wrapClientHttpRequestFactory(Optional.ofNullable(this.clientHttpRequestFactory).orElseGet(this::defaultClientHttpRequestFactory));
        CursorManager cursorManager = Optional.ofNullable(this.cursorManager).orElseGet(() -> new ManagedCursorManager(this.baseUri, clientHttpRequestFactory));
        ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : DefaultObjectMapper.INSTANCE;
        return new NakadiClient(this.baseUri, clientHttpRequestFactory, objectMapper, cursorManager);
    }
}

