/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.domain;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.zalando.fahrschein.domain.Cursor;

@Immutable
public class SubscriptionRequest {
    private final String owningApplication;
    private final Set<String> eventTypes;
    private final String consumerGroup;
    private final Position readFrom;
    private final List<Cursor> initialCursors;

    public SubscriptionRequest(String owningApplication, Set<String> eventTypes, String consumerGroup, Position readFrom, List<Cursor> initialCursors) {
        this.owningApplication = owningApplication;
        this.eventTypes = Collections.unmodifiableSet(eventTypes == null ? Collections.emptySet() : new HashSet<String>(eventTypes));
        this.consumerGroup = consumerGroup;
        this.readFrom = readFrom;
        this.initialCursors = Collections.unmodifiableList(initialCursors == null ? Collections.emptyList() : new ArrayList<Cursor>(initialCursors));
    }

    public SubscriptionRequest(String owningApplication, Set<String> eventTypes, String consumerGroup) {
        this(owningApplication, eventTypes, consumerGroup, Position.END, Collections.emptyList());
    }

    public String getOwningApplication() {
        return this.owningApplication;
    }

    public Set<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public Position getReadFrom() {
        return this.readFrom;
    }

    public List<Cursor> getInitialCursors() {
        return this.initialCursors;
    }

    public static enum Position {
        BEGIN("begin"),
        END("end"),
        CURSORS("cursors");

        private final String value;

        private Position(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

