/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.NakadiClientBuilder;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Subscription;

public class ManagedCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedCursorManager.class);
    private final URI baseUri;
    private final ClientHttpRequestFactory clientHttpRequestFactory;
    private final ObjectMapper objectMapper;
    private final Map<String, SubscriptionStream> streams;

    public ManagedCursorManager(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, AccessTokenProvider accessTokenProvider) {
        this(baseUri, NakadiClientBuilder.wrapClientHttpRequestFactory(clientHttpRequestFactory, accessTokenProvider), true);
    }

    public ManagedCursorManager(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory) {
        this(baseUri, NakadiClientBuilder.wrapClientHttpRequestFactory(clientHttpRequestFactory, null), true);
    }

    ManagedCursorManager(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, boolean clientHttpRequestFactoryIsAlreadyWrapped) {
        this.baseUri = baseUri;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.objectMapper = DefaultObjectMapper.INSTANCE;
        this.streams = new ConcurrentHashMap<String, SubscriptionStream>();
    }

    @Override
    public void addSubscription(Subscription subscription) {
        for (String eventName : subscription.getEventTypes()) {
            LOG.debug("Adding subscription [{}] to event [{}]", (Object)subscription.getId(), (Object)eventName);
            this.streams.put(eventName, new SubscriptionStream(eventName, subscription.getId()));
        }
    }

    @Override
    public void addStreamId(Subscription subscription, String streamId) {
        for (String eventName : subscription.getEventTypes()) {
            LOG.debug("Adding stream id [{}] for subscription [{}] to event [{}]", new Object[]{streamId, subscription.getId(), eventName});
            this.streams.get(eventName).setStreamId(streamId);
        }
    }

    @Override
    public void onSuccess(String eventName, Cursor cursor) throws IOException {
        block27: {
            SubscriptionStream stream = this.streams.get(eventName);
            String subscriptionId = stream.getSubscriptionId();
            URI subscriptionUrl = this.baseUri.resolve(String.format("/subscriptions/%s/cursors", subscriptionId));
            LOG.debug("Committing cursors for subscription [{}] to event [{}] in partition [{}] with offset [{}]", new Object[]{subscriptionId, stream.getEventName(), cursor.getPartition(), cursor.getOffset()});
            ClientHttpRequest request = this.clientHttpRequestFactory.createRequest(subscriptionUrl, HttpMethod.POST);
            request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            request.getHeaders().put("X-Nakadi-StreamId", Collections.singletonList(stream.getStreamId()));
            try (OutputStream os = request.getBody();){
                this.objectMapper.writeValue(os, (Object)new CursorWrapper(Collections.singletonList(cursor)));
            }
            var8_8 = null;
            try (ClientHttpResponse response = request.execute();){
                int status = response.getStatusCode().value();
                if (status == 204) {
                    LOG.debug("Successfully committed cursor for subscription [{}] to event [{}] in partition [{}] with offset [{}]", new Object[]{subscriptionId, eventName, cursor.getPartition(), cursor.getOffset()});
                    break block27;
                }
                if (status == 200) {
                    LOG.warn("Cursor for subscription [{}] to event [{}] in partition [{}] with offset [{}] was already committed", new Object[]{subscriptionId, eventName, cursor.getPartition(), cursor.getOffset()});
                    break block27;
                }
                throw new IOException(String.format("Unexpected status code [%s] for subscription [%s] to event [%s]", status, subscriptionId, eventName));
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
        }
    }

    @Override
    public void onSuccess(String eventName, List<Cursor> cursors) throws IOException {
        for (Cursor cursor : cursors) {
            this.onSuccess(eventName, cursor);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Collection<Cursor> getCursors(String eventName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static final class CursorWrapper {
        private final List<Cursor> items;

        @JsonCreator
        CursorWrapper(@JsonProperty(value="items") List<Cursor> items) {
            this.items = items;
        }

        public List<Cursor> getItems() {
            return this.items;
        }
    }

    static final class SubscriptionStream {
        private final String eventName;
        private final String subscriptionId;
        private String streamId;

        SubscriptionStream(String eventName, String subscriptionId) {
            this.eventName = eventName;
            this.subscriptionId = subscriptionId;
        }

        String getEventName() {
            return this.eventName;
        }

        String getSubscriptionId() {
            return this.subscriptionId;
        }

        String getStreamId() {
            return this.streamId;
        }

        void setStreamId(String streamId) {
            this.streamId = streamId;
        }
    }
}

