/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.EventPublishingException;
import org.zalando.fahrschein.ManagedCursorManager;
import org.zalando.fahrschein.NakadiClientBuilder;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.StreamBuilder;
import org.zalando.fahrschein.StreamBuilders;
import org.zalando.fahrschein.SubscriptionBuilder;
import org.zalando.fahrschein.domain.BatchItemResponse;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Partition;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.fahrschein.domain.SubscriptionRequest;

public class NakadiClient {
    private static final Logger LOG = LoggerFactory.getLogger(NakadiClient.class);
    private static final TypeReference<List<Partition>> LIST_OF_PARTITIONS = new TypeReference<List<Partition>>(){};
    private final URI baseUri;
    private final ClientHttpRequestFactory clientHttpRequestFactory;
    private final ObjectMapper internalObjectMapper;
    private final ObjectMapper objectMapper;
    private final CursorManager cursorManager;

    public static NakadiClientBuilder builder(URI baseUri) {
        return new NakadiClientBuilder(baseUri);
    }

    NakadiClient(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, ObjectMapper objectMapper, CursorManager cursorManager) {
        this.baseUri = baseUri;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.objectMapper = objectMapper;
        this.internalObjectMapper = DefaultObjectMapper.INSTANCE;
        this.cursorManager = cursorManager;
    }

    /*
     * Exception decompiling
     */
    public List<Partition> getPartitions(String eventName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> void publish(String eventName, List<T> events) throws IOException {
        block39: {
            URI uri = this.baseUri.resolve(String.format("/event-types/%s/events", eventName));
            ClientHttpRequest request = this.clientHttpRequestFactory.createRequest(uri, HttpMethod.POST);
            request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            try (OutputStream body = request.getBody();){
                this.objectMapper.writeValue(body, events);
            }
            var6_6 = null;
            try (ClientHttpResponse response = request.execute();){
                MediaType contentType = response.getHeaders().getContentType();
                if (contentType == null || !MediaType.APPLICATION_JSON.getType().equals(contentType.getType()) || !MediaType.APPLICATION_JSON.getSubtype().equals(contentType.getSubtype())) break block39;
                try (InputStream is = response.getBody();){
                    BatchItemResponse[] responses = (BatchItemResponse[])this.internalObjectMapper.readValue(is, BatchItemResponse[].class);
                    ArrayList<BatchItemResponse> failed = new ArrayList<BatchItemResponse>(responses.length);
                    for (BatchItemResponse batchItemResponse : responses) {
                        if (batchItemResponse.getPublishingStatus() == BatchItemResponse.PublishingStatus.SUBMITTED) continue;
                        failed.add(batchItemResponse);
                    }
                    if (!failed.isEmpty()) {
                        throw new EventPublishingException(failed.toArray(new BatchItemResponse[failed.size()]));
                    }
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
    }

    @Deprecated
    public Subscription subscribe(String applicationName, String eventName, String consumerGroup) throws IOException {
        return this.subscription(applicationName, eventName).withConsumerGroup(consumerGroup).subscribe();
    }

    public SubscriptionBuilder subscription(String applicationName, String eventName) throws IOException {
        return new SubscriptionBuilder(this, applicationName, Collections.singleton(eventName));
    }

    public SubscriptionBuilder subscription(String applicationName, Set<String> eventNames) throws IOException {
        return new SubscriptionBuilder(this, applicationName, eventNames);
    }

    public void deleteSubscription(String subscriptionId) throws IOException {
        Preconditions.checkArgument(!subscriptionId.isEmpty(), "Subscription ID cannot be empty.");
        URI uri = this.baseUri.resolve(String.format("/subscriptions/%s", subscriptionId));
        ClientHttpRequest request = this.clientHttpRequestFactory.createRequest(uri, HttpMethod.DELETE);
        request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        try (ClientHttpResponse response = request.execute();){
            int status = response.getStatusCode().value();
            if (status == 204) {
                LOG.debug("Successfully deleted subscription [{}]", (Object)subscriptionId);
            }
        }
    }

    /*
     * Exception decompiling
     */
    Subscription subscribe(String applicationName, Set<String> eventNames, String consumerGroup, SubscriptionRequest.Position readFrom, @Nullable List<Cursor> initialCursors) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StreamBuilder.SubscriptionStreamBuilder stream(Subscription subscription) {
        Preconditions.checkState(this.cursorManager instanceof ManagedCursorManager, "Subscription api requires a ManagedCursorManager");
        return new StreamBuilders.SubscriptionStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.objectMapper, subscription);
    }

    public StreamBuilder.LowLevelStreamBuilder stream(String eventName) {
        return new StreamBuilders.LowLevelStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.objectMapper, eventName);
    }
}

