/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.fahrschein.domain.SubscriptionRequest;

public class SubscriptionBuilder {
    private static final String DEFAULT_CONSUMER_GROUP = "default";
    private final NakadiClient nakadiClient;
    private final String applicationName;
    private final Set<String> eventNames;
    private final String consumerGroup;
    private final SubscriptionRequest.Position readFrom;
    @Nullable
    private final List<Cursor> initialCursors;

    SubscriptionBuilder(NakadiClient nakadiClient, String applicationName, Set<String> eventNames) {
        this(nakadiClient, applicationName, eventNames, DEFAULT_CONSUMER_GROUP, SubscriptionRequest.Position.END, null);
    }

    private SubscriptionBuilder(NakadiClient nakadiClient, String applicationName, Set<String> eventNames, String consumerGroup, SubscriptionRequest.Position readFrom, @Nullable List<Cursor> initialCursors) {
        this.nakadiClient = nakadiClient;
        this.applicationName = applicationName;
        this.eventNames = eventNames;
        this.consumerGroup = consumerGroup;
        this.readFrom = readFrom;
        this.initialCursors = initialCursors;
    }

    public SubscriptionBuilder readFromBegin() {
        Preconditions.checkState(this.initialCursors == null, "Initial cursors can not be specified when reading from 'begin'");
        return new SubscriptionBuilder(this.nakadiClient, this.applicationName, this.eventNames, this.consumerGroup, SubscriptionRequest.Position.BEGIN, null);
    }

    public SubscriptionBuilder readFromEnd() {
        Preconditions.checkState(this.initialCursors == null, "Initial cursors can not be specified when reading from 'end'");
        return new SubscriptionBuilder(this.nakadiClient, this.applicationName, this.eventNames, this.consumerGroup, SubscriptionRequest.Position.END, null);
    }

    public SubscriptionBuilder readFromCursors(List<Cursor> initialCursors) {
        Preconditions.checkArgument(initialCursors != null, "Initial cursors have to be specified");
        return new SubscriptionBuilder(this.nakadiClient, this.applicationName, this.eventNames, this.consumerGroup, SubscriptionRequest.Position.CURSORS, initialCursors);
    }

    public SubscriptionBuilder withConsumerGroup(String consumerGroup) {
        return new SubscriptionBuilder(this.nakadiClient, this.applicationName, this.eventNames, consumerGroup, this.readFrom, this.initialCursors);
    }

    public Subscription subscribe() throws IOException {
        return this.nakadiClient.subscribe(this.applicationName, this.eventNames, this.consumerGroup, this.readFrom, this.initialCursors);
    }
}

