/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.IOProblem;
import org.zalando.fahrschein.http.api.ContentType;
import org.zalando.fahrschein.http.api.Headers;
import org.zalando.fahrschein.http.api.Request;
import org.zalando.fahrschein.http.api.Response;

class ProblemHandlingRequest
implements Request {
    private static final URI DEFAULT_PROBLEM_TYPE = URI.create("about:blank");
    private final Request request;
    private final ObjectMapper objectMapper;

    public ProblemHandlingRequest(Request request) {
        this.request = request;
        this.objectMapper = DefaultObjectMapper.INSTANCE;
    }

    public Response execute() throws IOException {
        Response response = this.request.execute();
        try {
            int statusCode = response.getStatusCode();
            if (statusCode >= 400 && statusCode != 422) {
                String statusText = response.getStatusText();
                ContentType contentType = response.getHeaders().getContentType();
                if (ProblemHandlingRequest.isProblem(contentType)) {
                    InputStream is = response.getBody();
                    Throwable throwable = null;
                    try {
                        try {
                            IOProblem problem = this.deserializeProblem(is, statusCode);
                            if (problem != null) {
                                throw problem;
                            }
                            throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusText, statusCode);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusText, statusCode);
            }
        }
        catch (Throwable throwable) {
            try {
                response.close();
            }
            catch (Throwable suppressed) {
                throwable.addSuppressed(suppressed);
            }
            throw throwable;
        }
        return response;
    }

    private static boolean isProblem(ContentType contentType) {
        return ContentType.APPLICATION_JSON.getType().equals(contentType.getType()) && ContentType.APPLICATION_JSON.getSubtype().equals(contentType.getSubtype()) || ContentType.APPLICATION_PROBLEM_JSON.getType().equals(contentType.getType()) && ContentType.APPLICATION_PROBLEM_JSON.getSubtype().equals(contentType.getSubtype());
    }

    @Nullable
    private IOProblem deserializeProblem(InputStream is, int statusCode) throws IOException {
        JsonNode rootNode = this.objectMapper.readTree(is);
        JsonNode typeNode = rootNode.get("type");
        JsonNode titleNode = rootNode.get("title");
        if (typeNode != null && titleNode != null) {
            String type = typeNode.asText();
            String title = titleNode.asText();
            JsonNode detailNode = rootNode.get("detail");
            String detail = detailNode == null ? null : detailNode.asText(null);
            JsonNode instanceNode = rootNode.get("instance");
            String instance = instanceNode == null ? null : instanceNode.asText(null);
            return new IOProblem(URI.create(type), title, statusCode, detail, instance == null ? null : URI.create(instance));
        }
        JsonNode errorNode = rootNode.get("error");
        JsonNode descriptionNode = rootNode.get("error_description");
        if (errorNode != null && descriptionNode != null) {
            String error = errorNode.asText();
            String description = descriptionNode.asText();
            return new IOProblem(DEFAULT_PROBLEM_TYPE, error, statusCode, description);
        }
        return null;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public Headers getHeaders() {
        return this.request.getHeaders();
    }

    public OutputStream getBody() throws IOException {
        return this.request.getBody();
    }
}

