/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.AccessTokenProvider;

public class ZignAccessTokenProvider
implements AccessTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ZignAccessTokenProvider.class);
    private static final long CACHE_DURATION = 300000L;
    private final AtomicReference<Entry> token = new AtomicReference();

    private static String readAll(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            int len;
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * Loose catch block
     */
    private static String zign() throws IOException {
        LOG.info("Refreshing token from zign...");
        Process zign = new ProcessBuilder("zign", "token", "uid").start();
        try {
            try (InputStream inputStream = zign.getInputStream();){
                String string = ZignAccessTokenProvider.readAll(inputStream).trim();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            LOG.debug("Refreshed token from zign");
        }
    }

    private static Entry update(@Nullable Entry entry) {
        long now = System.currentTimeMillis();
        try {
            return entry == null || entry.timestamp < now - 300000L ? new Entry(now, ZignAccessTokenProvider.zign()) : entry;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getAccessToken() throws IOException {
        try {
            return this.token.updateAndGet((UnaryOperator<Entry>)(UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, update(org.zalando.fahrschein.ZignAccessTokenProvider$Entry ), (Lorg/zalando/fahrschein/ZignAccessTokenProvider$Entry;)Lorg/zalando/fahrschein/ZignAccessTokenProvider$Entry;)()).value;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    static class Entry {
        final long timestamp;
        final String value;

        Entry(long timestamp, String value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

