/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.zalando.fahrschein.domain.Authorization;

public class AuthorizationBuilder {
    private final List<Authorization.AuthorizationAttribute> admins;
    private final List<Authorization.AuthorizationAttribute> readers;

    private AuthorizationBuilder(List<Authorization.AuthorizationAttribute> admins, List<Authorization.AuthorizationAttribute> readers) {
        this.admins = admins;
        this.readers = readers;
    }

    public static AuthorizationBuilder authorization() {
        return new AuthorizationBuilder(Collections.emptyList(), Collections.emptyList());
    }

    public AuthorizationBuilder withAdmins(List<Authorization.AuthorizationAttribute> admins) {
        return new AuthorizationBuilder(admins, this.readers);
    }

    public AuthorizationBuilder withReaders(List<Authorization.AuthorizationAttribute> readers) {
        return new AuthorizationBuilder(this.admins, readers);
    }

    public AuthorizationBuilder withAdmins(Authorization.AuthorizationAttribute ... admins) {
        return new AuthorizationBuilder(Arrays.asList(admins), this.readers);
    }

    public AuthorizationBuilder withReaders(Authorization.AuthorizationAttribute ... readers) {
        return new AuthorizationBuilder(this.admins, Arrays.asList(readers));
    }

    public AuthorizationBuilder addAdmin(String dataType, String value) {
        ArrayList<Authorization.AuthorizationAttribute> newAdmins = new ArrayList<Authorization.AuthorizationAttribute>(this.admins.size() + 1);
        newAdmins.addAll(this.admins);
        newAdmins.add(new Authorization.AuthorizationAttribute(dataType, value));
        return this.withAdmins(newAdmins);
    }

    public AuthorizationBuilder addReader(String dataType, String value) {
        ArrayList<Authorization.AuthorizationAttribute> newReaders = new ArrayList<Authorization.AuthorizationAttribute>(this.readers.size() + 1);
        newReaders.addAll(this.readers);
        newReaders.add(new Authorization.AuthorizationAttribute(dataType, value));
        return this.withReaders(newReaders);
    }

    public Authorization build() {
        List<Authorization.AuthorizationAttribute> admins = this.admins.isEmpty() ? Collections.singletonList(Authorization.AuthorizationAttribute.ANYONE) : this.admins;
        List<Authorization.AuthorizationAttribute> readers = this.readers.isEmpty() ? Collections.singletonList(Authorization.AuthorizationAttribute.ANYONE) : this.readers;
        return new Authorization(admins, readers);
    }
}

