/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.EventPublishingException;
import org.zalando.fahrschein.IOProblem;
import org.zalando.fahrschein.domain.BatchItemResponse;
import org.zalando.fahrschein.http.api.ContentType;
import org.zalando.fahrschein.http.api.Headers;
import org.zalando.fahrschein.http.api.Request;
import org.zalando.fahrschein.http.api.Response;

class ProblemHandlingRequest
implements Request {
    private static final URI DEFAULT_PROBLEM_TYPE = URI.create("about:blank");
    private final Request request;
    private final ObjectMapper objectMapper;

    ProblemHandlingRequest(Request request) {
        this.request = request;
        this.objectMapper = DefaultObjectMapper.INSTANCE;
    }

    public Response execute() throws IOException {
        Response response;
        block8: {
            response = this.request.execute();
            try {
                int statusCode = response.getStatusCode();
                if (statusCode != 207 && statusCode < 400) break block8;
                String statusText = response.getStatusText();
                Headers headers = response.getHeaders();
                ContentType contentType = headers.getContentType();
                if (ProblemHandlingRequest.mightBeProblematic(contentType)) {
                    JsonNode json = this.objectMapper.readTree(response.getBody());
                    if (ProblemHandlingRequest.isBatchItemResponse(json)) {
                        this.handleBatchItemResponse(json);
                        break block8;
                    }
                    if (ProblemHandlingRequest.isAuthError(json)) {
                        this.handleAuthError(json, statusCode);
                        break block8;
                    }
                    if (ProblemHandlingRequest.isProblem(json)) {
                        this.handleProblem(json, statusCode);
                        break block8;
                    }
                    throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusText, statusCode);
                }
                throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusText, statusCode);
            }
            catch (Throwable throwable) {
                try {
                    response.close();
                }
                catch (Throwable suppressed) {
                    throwable.addSuppressed(suppressed);
                }
                throw throwable;
            }
        }
        return response;
    }

    private static boolean mightBeProblematic(ContentType contentType) {
        String type = contentType.getType();
        String subtype = contentType.getSubtype();
        return ContentType.APPLICATION_JSON.getType().equals(type) && ContentType.APPLICATION_JSON.getSubtype().equals(subtype) || ContentType.APPLICATION_PROBLEM_JSON.getType().equals(type) && ContentType.APPLICATION_PROBLEM_JSON.getSubtype().equals(subtype);
    }

    private static boolean isProblem(JsonNode json) {
        return json.has("title");
    }

    private static boolean isAuthError(JsonNode json) {
        return json.has("error") && json.has("error_description");
    }

    private static boolean isBatchItemResponse(JsonNode json) {
        return json.isArray() && json.size() > 0 && json.get(0).has("publishing_status");
    }

    private void handleProblem(JsonNode rootNode, int statusCode) throws IOException {
        JsonNode typeNode = rootNode.get("type");
        String type = typeNode == null ? "about:blank" : typeNode.asText();
        String title = rootNode.get("title").asText();
        JsonNode detailNode = rootNode.get("detail");
        String detail = detailNode == null ? null : detailNode.asText(null);
        JsonNode instanceNode = rootNode.get("instance");
        String instance = instanceNode == null ? null : instanceNode.asText(null);
        throw new IOProblem(URI.create(type), title, statusCode, detail, instance == null ? null : URI.create(instance));
    }

    private void handleAuthError(JsonNode rootNode, int statusCode) throws IOProblem {
        String error = rootNode.get("error").asText();
        String description = rootNode.get("error_description").asText();
        throw new IOProblem(DEFAULT_PROBLEM_TYPE, error, statusCode, description);
    }

    private void handleBatchItemResponse(JsonNode rootNode) throws IOException {
        BatchItemResponse[] responses = (BatchItemResponse[])this.objectMapper.treeToValue((TreeNode)rootNode, BatchItemResponse[].class);
        ArrayList<BatchItemResponse> failed = new ArrayList<BatchItemResponse>(responses.length);
        for (BatchItemResponse batchItemResponse : responses) {
            if (batchItemResponse.getPublishingStatus() == BatchItemResponse.PublishingStatus.SUBMITTED) continue;
            failed.add(batchItemResponse);
        }
        if (!failed.isEmpty()) {
            throw new EventPublishingException(failed.toArray(new BatchItemResponse[failed.size()]));
        }
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public Headers getHeaders() {
        return this.request.getHeaders();
    }

    public OutputStream getBody() throws IOException {
        return this.request.getBody();
    }
}

